﻿using System;
using System.Web;
using VIRP.AHOBPR.BLL;

namespace VIRP_WEB.Custom.BPR.Registrants
{
    public partial class RegistrantDeploymentHistory : BprBasePage
    {
        //AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

        protected void Page_Load(object sender, EventArgs e)
        {

            int registrantId = Request.QueryString["id"] == null ? UserSession.RegistrantId : int.Parse(Request.QueryString["id"]);
            UserSession.RegistrantId = registrantId;
            LoadControlsFromObject(registrantId);
            //var master = (this.Master as RegistryMaster);
            //if (master != null)
            //{
            //    master.SetDirtyFlag(false);
            //}
        }

        public override string TopMenuName()
        {
            return "Registrants";
        }

        private void LoadControlsFromObject(int registrantId)
        {
            HiddenFieldRegistrantId.Value = registrantId.ToString();
            UserControlRegistrant.LoadUserControl(registrantId);
            UserControlAllDeployments.LoadUserControl(registrantId);
            string registrantName = REGISTRANTManager.GetUserIdByRegistrantId(registrantId);
            LabelBreadCrumb.Text = "<H1>Registrants > Registrant: " + registrantName + " > Deployment History</H1>";
        }

        public override string MenuItemName()
        {
            return "Deployment History";
        }

        public override string AppObjectCode()
        {
            return "AHOBPR DEPLOYMENT HISTORY";
        }
    }
}